package net.mintern.functions.binary;

/**
 * An operation of type {@code (long, byte) -> short}.
 *
 */
@FunctionalInterface
public interface LongByteToShort extends
        net.mintern.functions.binary.checked.LongByteToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.LongByteToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> LongByteToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.LongByteToShortE<E> f) {
        return (l, b) -> {
            try {
                return f.call(l, b);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> LongByteToShort unchecked(
            net.mintern.functions.binary.checked.LongByteToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> LongByteToShort uncheckedIO(
            net.mintern.functions.binary.checked.LongByteToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(l, b)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToShort
    bind(LongByteToShort f, long l) {
        return (b) -> f.call(l, b);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(l, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort bind(long l) {
        return LongByteToShort.bind(this, l);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, b)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    rbind(LongByteToShort f, byte b) {
        return (l) -> f.call(l, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param b argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort rbind(byte b) {
        return LongByteToShort.rbind(this, b);
    }

    /**
     * Binds {@code (l, b)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param l argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, b)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(LongByteToShort f, long l, byte b) {
        return () -> f.call(l, b);
    }

    /**
     * Binds {@code (l, b)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(long l, byte b) {
        return LongByteToShort.bind(this, l, b);
    }
}
