package net.mintern.functions.binary;

/**
 * An operation of type {@code (long, char) -> short}.
 *
 */
@FunctionalInterface
public interface LongCharToShort extends
        net.mintern.functions.binary.checked.LongCharToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.LongCharToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> LongCharToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.LongCharToShortE<E> f) {
        return (l, ch) -> {
            try {
                return f.call(l, ch);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> LongCharToShort unchecked(
            net.mintern.functions.binary.checked.LongCharToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> LongCharToShort uncheckedIO(
            net.mintern.functions.binary.checked.LongCharToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(l, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    bind(LongCharToShort f, long l) {
        return (ch) -> f.call(l, ch);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(l, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort bind(long l) {
        return LongCharToShort.bind(this, l);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    rbind(LongCharToShort f, char ch) {
        return (l) -> f.call(l, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort rbind(char ch) {
        return LongCharToShort.rbind(this, ch);
    }

    /**
     * Binds {@code (l, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param l argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, ch)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(LongCharToShort f, long l, char ch) {
        return () -> f.call(l, ch);
    }

    /**
     * Binds {@code (l, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(long l, char ch) {
        return LongCharToShort.bind(this, l, ch);
    }
}
