package net.mintern.functions.binary;

/**
 * An operation of type {@code (long, long) -> short}.
 *
 */
@FunctionalInterface
public interface LongLongToShort extends
        net.mintern.functions.binary.checked.LongLongToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.LongLongToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> LongLongToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.LongLongToShortE<E> f) {
        return (l1, l2) -> {
            try {
                return f.call(l1, l2);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> LongLongToShort unchecked(
            net.mintern.functions.binary.checked.LongLongToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> LongLongToShort uncheckedIO(
            net.mintern.functions.binary.checked.LongLongToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (l1)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param l1 argument 1
     * @return a new function {@code (long l2) -> short} that calls
     *      {@code f.call(l1, l2)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    bind(LongLongToShort f, long l1) {
        return (l2) -> f.call(l1, l2);
    }

    /**
     * Binds {@code (l1)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param l1 argument 1
     * @return a new function {@code (long l2) -> short} that calls
     *      {@code this.call(l1, l2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort bind(long l1) {
        return LongLongToShort.bind(this, l1);
    }

    /**
     * Binds {@code (l2)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param f the unbound function
     * @param l2 argument 2
     * @return a new function {@code (long l1) -> short} that calls
     *      {@code f.call(l1, l2)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToShort
    rbind(LongLongToShort f, long l2) {
        return (l1) -> f.call(l1, l2);
    }

    /**
     * Binds {@code (l2)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param l2 argument 2
     * @return a new function {@code (long l1) -> short} that calls
     *      {@code this.call(l1, l2)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort rbind(long l2) {
        return LongLongToShort.rbind(this, l2);
    }

    /**
     * Binds {@code (l1, l2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param l1 argument 1
     * @param l2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l1, l2)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(LongLongToShort f, long l1, long l2) {
        return () -> f.call(l1, l2);
    }

    /**
     * Binds {@code (l1, l2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l1 argument 1
     * @param l2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l1, l2)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(long l1, long l2) {
        return LongLongToShort.bind(this, l1, l2);
    }
}
