package net.mintern.functions.binary;

/**
 * An operation of type {@code (long, short) -> float}.
 *
 */
@FunctionalInterface
public interface LongShortToFloat extends
        net.mintern.functions.binary.checked.LongShortToFloatE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.LongShortToFloatE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> LongShortToFloat unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.LongShortToFloatE<E> f) {
        return (l, sh) -> {
            try {
                return f.call(l, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> LongShortToFloat unchecked(
            net.mintern.functions.binary.checked.LongShortToFloatE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> LongShortToFloat uncheckedIO(
            net.mintern.functions.binary.checked.LongShortToFloatE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToFloat
    bind(LongShortToFloat f, long l) {
        return (sh) -> f.call(l, sh);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param l argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToFloat bind(long l) {
        return LongShortToFloat.bind(this, l);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> float}.
     *
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (long l) -> float} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToFloat
    rbind(LongShortToFloat f, short sh) {
        return (l) -> f.call(l, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> float}.
     *
     * @param sh argument 2
     * @return a new function {@code (long l) -> float} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToFloat rbind(short sh) {
        return LongShortToFloat.rbind(this, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param f the unbound function
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToFloat
    bind(LongShortToFloat f, long l, short sh) {
        return () -> f.call(l, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToFloat bind(long l, short sh) {
        return LongShortToFloat.bind(this, l, sh);
    }
}
