package net.mintern.functions.binary;

/**
 * An operation of type {@code (T, byte) -> short}.
 *
 * @param <T> the type of the argument
 */
@FunctionalInterface
public interface ObjByteToShort<T> extends
        net.mintern.functions.binary.checked.ObjByteToShortE<T, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ObjByteToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <T, E extends Exception> ObjByteToShort<T> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ObjByteToShortE<T, E> f) {
        return (t, b) -> {
            try {
                return f.call(t, b);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <T, E extends Exception> ObjByteToShort<T> unchecked(
            net.mintern.functions.binary.checked.ObjByteToShortE<T, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <T, E extends java.io.IOException> ObjByteToShort<T> uncheckedIO(
            net.mintern.functions.binary.checked.ObjByteToShortE<T, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(t, b)} and returns the result.
     */
    static <T> net.mintern.functions.unary.ByteToShort
    bind(ObjByteToShort<T> f, T t) {
        return (b) -> f.call(t, b);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(t, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToShort bind(T t) {
        return ObjByteToShort.bind(this, t);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, b)} and returns the result.
     */
    static <T> net.mintern.functions.unary.ObjToShort<T>
    rbind(ObjByteToShort<T> f, byte b) {
        return (t) -> f.call(t, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param b argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<T> rbind(byte b) {
        return ObjByteToShort.rbind(this, b);
    }

    /**
     * Binds {@code (t, b)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, b)} and returns the result.
     */
    static <T> net.mintern.functions.nullary.NilToShort
    bind(ObjByteToShort<T> f, T t, byte b) {
        return () -> f.call(t, b);
    }

    /**
     * Binds {@code (t, b)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(T t, byte b) {
        return ObjByteToShort.bind(this, t, b);
    }
}
