package net.mintern.functions.binary;

/**
 * An operation of type {@code (T, float) -> short}.
 *
 * @param <T> the type of the argument
 */
@FunctionalInterface
public interface ObjFloatToShort<T> extends
        net.mintern.functions.binary.checked.ObjFloatToShortE<T, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ObjFloatToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <T, E extends Exception> ObjFloatToShort<T> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ObjFloatToShortE<T, E> f) {
        return (t, fl) -> {
            try {
                return f.call(t, fl);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <T, E extends Exception> ObjFloatToShort<T> unchecked(
            net.mintern.functions.binary.checked.ObjFloatToShortE<T, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <T, E extends java.io.IOException> ObjFloatToShort<T> uncheckedIO(
            net.mintern.functions.binary.checked.ObjFloatToShortE<T, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(t, fl)} and returns the result.
     */
    static <T> net.mintern.functions.unary.FloatToShort
    bind(ObjFloatToShort<T> f, T t) {
        return (fl) -> f.call(t, fl);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(t, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort bind(T t) {
        return ObjFloatToShort.bind(this, t);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, fl)} and returns the result.
     */
    static <T> net.mintern.functions.unary.ObjToShort<T>
    rbind(ObjFloatToShort<T> f, float fl) {
        return (t) -> f.call(t, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<T> rbind(float fl) {
        return ObjFloatToShort.rbind(this, fl);
    }

    /**
     * Binds {@code (t, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, fl)} and returns the result.
     */
    static <T> net.mintern.functions.nullary.NilToShort
    bind(ObjFloatToShort<T> f, T t, float fl) {
        return () -> f.call(t, fl);
    }

    /**
     * Binds {@code (t, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(T t, float fl) {
        return ObjFloatToShort.bind(this, t, fl);
    }
}
