package net.mintern.functions.binary;

/**
 * An operation of type {@code (T, long) -> short}.
 *
 * @param <T> the type of the argument
 */
@FunctionalInterface
public interface ObjLongToShort<T> extends
        net.mintern.functions.binary.checked.ObjLongToShortE<T, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ObjLongToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <T, E extends Exception> ObjLongToShort<T> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ObjLongToShortE<T, E> f) {
        return (t, l) -> {
            try {
                return f.call(t, l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <T, E extends Exception> ObjLongToShort<T> unchecked(
            net.mintern.functions.binary.checked.ObjLongToShortE<T, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <T, E extends java.io.IOException> ObjLongToShort<T> uncheckedIO(
            net.mintern.functions.binary.checked.ObjLongToShortE<T, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(t, l)} and returns the result.
     */
    static <T> net.mintern.functions.unary.LongToShort
    bind(ObjLongToShort<T> f, T t) {
        return (l) -> f.call(t, l);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(t, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToShort bind(T t) {
        return ObjLongToShort.bind(this, t);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, l)} and returns the result.
     */
    static <T> net.mintern.functions.unary.ObjToShort<T>
    rbind(ObjLongToShort<T> f, long l) {
        return (t) -> f.call(t, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToShort<T> rbind(long l) {
        return ObjLongToShort.rbind(this, l);
    }

    /**
     * Binds {@code (t, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, l)} and returns the result.
     */
    static <T> net.mintern.functions.nullary.NilToShort
    bind(ObjLongToShort<T> f, T t, long l) {
        return () -> f.call(t, l);
    }

    /**
     * Binds {@code (t, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(T t, long l) {
        return ObjLongToShort.bind(this, t, l);
    }
}
