package net.mintern.functions.binary;

/**
 * An operation of type {@code (T, short) -> char}.
 *
 * @param <T> the type of the argument
 */
@FunctionalInterface
public interface ObjShortToChar<T> extends
        net.mintern.functions.binary.checked.ObjShortToCharE<T, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ObjShortToCharE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <T, E extends Exception> ObjShortToChar<T> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ObjShortToCharE<T, E> f) {
        return (t, sh) -> {
            try {
                return f.call(t, sh);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <T, E extends Exception> ObjShortToChar<T> unchecked(
            net.mintern.functions.binary.checked.ObjShortToCharE<T, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <T, E extends java.io.IOException> ObjShortToChar<T> uncheckedIO(
            net.mintern.functions.binary.checked.ObjShortToCharE<T, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    static <T> net.mintern.functions.unary.ShortToChar
    bind(ObjShortToChar<T> f, T t) {
        return (sh) -> f.call(t, sh);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param t argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToChar bind(T t) {
        return ObjShortToChar.bind(this, t);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> char}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (T t) -> char} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    static <T> net.mintern.functions.unary.ObjToChar<T>
    rbind(ObjShortToChar<T> f, short sh) {
        return (t) -> f.call(t, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> char}.
     *
     * @param sh argument 2
     * @return a new function {@code (T t) -> char} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToChar<T> rbind(short sh) {
        return ObjShortToChar.rbind(this, sh);
    }

    /**
     * Binds {@code (t, sh)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param <T> the type of the argument
     * @param f the unbound function
     * @param t argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    static <T> net.mintern.functions.nullary.NilToChar
    bind(ObjShortToChar<T> f, T t, short sh) {
        return () -> f.call(t, sh);
    }

    /**
     * Binds {@code (t, sh)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param t argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToChar bind(T t, short sh) {
        return ObjShortToChar.bind(this, t, sh);
    }
}
