package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, boolean) -> long}.
 *
 */
@FunctionalInterface
public interface ShortBoolToLong extends
        net.mintern.functions.binary.checked.ShortBoolToLongE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortBoolToLongE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortBoolToLong unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortBoolToLongE<E> f) {
        return (sh, bool) -> {
            try {
                return f.call(sh, bool);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortBoolToLong unchecked(
            net.mintern.functions.binary.checked.ShortBoolToLongE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortBoolToLong uncheckedIO(
            net.mintern.functions.binary.checked.ShortBoolToLongE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> long}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> long} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.BoolToLong
    bind(ShortBoolToLong f, short sh) {
        return (bool) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> long}.
     *
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> long} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.BoolToLong bind(short sh) {
        return ShortBoolToLong.bind(this, sh);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToLong
    rbind(ShortBoolToLong f, boolean bool) {
        return (sh) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param bool argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToLong rbind(boolean bool) {
        return ShortBoolToLong.rbind(this, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToLong
    bind(ShortBoolToLong f, short sh, boolean bool) {
        return () -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToLong bind(short sh, boolean bool) {
        return ShortBoolToLong.bind(this, sh, bool);
    }
}
