package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, byte) -> byte}.
 *
 */
@FunctionalInterface
public interface ShortByteToByte extends
        net.mintern.functions.binary.checked.ShortByteToByteE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortByteToByteE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortByteToByte unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortByteToByteE<E> f) {
        return (sh, b) -> {
            try {
                return f.call(sh, b);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortByteToByte unchecked(
            net.mintern.functions.binary.checked.ShortByteToByteE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortByteToByte uncheckedIO(
            net.mintern.functions.binary.checked.ShortByteToByteE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> byte}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (byte b) -> byte} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToByte
    bind(ShortByteToByte f, short sh) {
        return (b) -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> byte}.
     *
     * @param sh argument 1
     * @return a new function {@code (byte b) -> byte} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToByte bind(short sh) {
        return ShortByteToByte.bind(this, sh);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToByte
    rbind(ShortByteToByte f, byte b) {
        return (sh) -> f.call(sh, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param b argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToByte rbind(byte b) {
        return ShortByteToByte.rbind(this, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToByte
    bind(ShortByteToByte f, short sh, byte b) {
        return () -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToByte bind(short sh, byte b) {
        return ShortByteToByte.bind(this, sh, b);
    }
}
