package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, byte) -> double}.
 *
 */
@FunctionalInterface
public interface ShortByteToDbl extends
        net.mintern.functions.binary.checked.ShortByteToDblE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortByteToDblE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortByteToDbl unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortByteToDblE<E> f) {
        return (sh, b) -> {
            try {
                return f.call(sh, b);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortByteToDbl unchecked(
            net.mintern.functions.binary.checked.ShortByteToDblE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortByteToDbl uncheckedIO(
            net.mintern.functions.binary.checked.ShortByteToDblE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> double}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (byte b) -> double} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static  net.mintern.functions.unary.ByteToDbl
    bind(ShortByteToDbl f, short sh) {
        return (b) -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> double}.
     *
     * @param sh argument 1
     * @return a new function {@code (byte b) -> double} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ByteToDbl bind(short sh) {
        return ShortByteToDbl.bind(this, sh);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToDbl
    rbind(ShortByteToDbl f, byte b) {
        return (sh) -> f.call(sh, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param b argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToDbl rbind(byte b) {
        return ShortByteToDbl.rbind(this, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToDbl
    bind(ShortByteToDbl f, short sh, byte b) {
        return () -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToDbl bind(short sh, byte b) {
        return ShortByteToDbl.bind(this, sh, b);
    }
}
