package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, char) -> short}.
 *
 */
@FunctionalInterface
public interface ShortCharToShort extends
        net.mintern.functions.binary.checked.ShortCharToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortCharToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortCharToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortCharToShortE<E> f) {
        return (sh, ch) -> {
            try {
                return f.call(sh, ch);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortCharToShort unchecked(
            net.mintern.functions.binary.checked.ShortCharToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortCharToShort uncheckedIO(
            net.mintern.functions.binary.checked.ShortCharToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.CharToShort
    bind(ShortCharToShort f, short sh) {
        return (ch) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param sh argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.CharToShort bind(short sh) {
        return ShortCharToShort.bind(this, sh);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToShort
    rbind(ShortCharToShort f, char ch) {
        return (sh) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToShort rbind(char ch) {
        return ShortCharToShort.rbind(this, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ShortCharToShort f, short sh, char ch) {
        return () -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(short sh, char ch) {
        return ShortCharToShort.bind(this, sh, ch);
    }
}
