package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, double) -> int}.
 *
 */
@FunctionalInterface
public interface ShortDblToInt extends
        net.mintern.functions.binary.checked.ShortDblToIntE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortDblToIntE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortDblToInt unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortDblToIntE<E> f) {
        return (sh, d) -> {
            try {
                return f.call(sh, d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortDblToInt unchecked(
            net.mintern.functions.binary.checked.ShortDblToIntE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortDblToInt uncheckedIO(
            net.mintern.functions.binary.checked.ShortDblToIntE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> int}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (double d) -> int} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToInt
    bind(ShortDblToInt f, short sh) {
        return (d) -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> int}.
     *
     * @param sh argument 1
     * @return a new function {@code (double d) -> int} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToInt bind(short sh) {
        return ShortDblToInt.bind(this, sh);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToInt
    rbind(ShortDblToInt f, double d) {
        return (sh) -> f.call(sh, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param d argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToInt rbind(double d) {
        return ShortDblToInt.rbind(this, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToInt
    bind(ShortDblToInt f, short sh, double d) {
        return () -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToInt bind(short sh, double d) {
        return ShortDblToInt.bind(this, sh, d);
    }
}
