package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, double) -> short}.
 *
 */
@FunctionalInterface
public interface ShortDblToShort extends
        net.mintern.functions.binary.checked.ShortDblToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortDblToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortDblToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortDblToShortE<E> f) {
        return (sh, d) -> {
            try {
                return f.call(sh, d);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortDblToShort unchecked(
            net.mintern.functions.binary.checked.ShortDblToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortDblToShort uncheckedIO(
            net.mintern.functions.binary.checked.ShortDblToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static  net.mintern.functions.unary.DblToShort
    bind(ShortDblToShort f, short sh) {
        return (d) -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param sh argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.DblToShort bind(short sh) {
        return ShortDblToShort.bind(this, sh);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToShort
    rbind(ShortDblToShort f, double d) {
        return (sh) -> f.call(sh, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToShort rbind(double d) {
        return ShortDblToShort.rbind(this, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ShortDblToShort f, short sh, double d) {
        return () -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(short sh, double d) {
        return ShortDblToShort.bind(this, sh, d);
    }
}
