package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, float) -> void}.
 *
 */
@FunctionalInterface
public interface ShortFloatToNil extends
        net.mintern.functions.binary.checked.ShortFloatToNilE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortFloatToNilE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortFloatToNil unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortFloatToNilE<E> f) {
        return (sh, fl) -> {
            try {
                f.call(sh, fl);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortFloatToNil unchecked(
            net.mintern.functions.binary.checked.ShortFloatToNilE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortFloatToNil uncheckedIO(
            net.mintern.functions.binary.checked.ShortFloatToNilE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> void}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (float fl) -> void} that calls
     *      {@code f.call(sh, fl)}.
     */
    static  net.mintern.functions.unary.FloatToNil
    bind(ShortFloatToNil f, short sh) {
        return (fl) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> void}.
     *
     * @param sh argument 1
     * @return a new function {@code (float fl) -> void} that calls
     *      {@code this.call(sh, fl)}.
     */
    @Override
    default net.mintern.functions.unary.FloatToNil bind(short sh) {
        return ShortFloatToNil.bind(this, sh);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(sh, fl)}.
     */
    static  net.mintern.functions.unary.ShortToNil
    rbind(ShortFloatToNil f, float fl) {
        return (sh) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param fl argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(sh, fl)}.
     */
    @Override
    default net.mintern.functions.unary.ShortToNil rbind(float fl) {
        return ShortFloatToNil.rbind(this, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(sh, fl)}.
     */
    static  net.mintern.functions.nullary.NilToNil
    bind(ShortFloatToNil f, short sh, float fl) {
        return () -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(sh, fl)}.
     */
    @Override
    default net.mintern.functions.nullary.NilToNil bind(short sh, float fl) {
        return ShortFloatToNil.bind(this, sh, fl);
    }
}
