package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, float) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface ShortFloatToObj<R> extends
        net.mintern.functions.binary.checked.ShortFloatToObjE<R, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortFloatToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> ShortFloatToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortFloatToObjE<R, E> f) {
        return (sh, fl) -> {
            try {
                return f.call(sh, fl);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> ShortFloatToObj<R> unchecked(
            net.mintern.functions.binary.checked.ShortFloatToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> ShortFloatToObj<R> uncheckedIO(
            net.mintern.functions.binary.checked.ShortFloatToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (float fl) -> R} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <R> net.mintern.functions.unary.FloatToObj<R>
    bind(ShortFloatToObj<R> f, short sh) {
        return (fl) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> R}.
     *
     * @param sh argument 1
     * @return a new function {@code (float fl) -> R} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToObj<R> bind(short sh) {
        return ShortFloatToObj.bind(this, sh);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <R> net.mintern.functions.unary.ShortToObj<R>
    rbind(ShortFloatToObj<R> f, float fl) {
        return (sh) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param fl argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> rbind(float fl) {
        return ShortFloatToObj.rbind(this, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(ShortFloatToObj<R> f, short sh, float fl) {
        return () -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(short sh, float fl) {
        return ShortFloatToObj.bind(this, sh, fl);
    }
}
