package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, float) -> short}.
 *
 */
@FunctionalInterface
public interface ShortFloatToShort extends
        net.mintern.functions.binary.checked.ShortFloatToShortE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortFloatToShortE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortFloatToShort unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortFloatToShortE<E> f) {
        return (sh, fl) -> {
            try {
                return f.call(sh, fl);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortFloatToShort unchecked(
            net.mintern.functions.binary.checked.ShortFloatToShortE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortFloatToShort uncheckedIO(
            net.mintern.functions.binary.checked.ShortFloatToShortE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.FloatToShort
    bind(ShortFloatToShort f, short sh) {
        return (fl) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param sh argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.FloatToShort bind(short sh) {
        return ShortFloatToShort.bind(this, sh);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToShort
    rbind(ShortFloatToShort f, float fl) {
        return (sh) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToShort rbind(float fl) {
        return ShortFloatToShort.rbind(this, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToShort
    bind(ShortFloatToShort f, short sh, float fl) {
        return () -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToShort bind(short sh, float fl) {
        return ShortFloatToShort.bind(this, sh, fl);
    }
}
