package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, int) -> boolean}.
 *
 */
@FunctionalInterface
public interface ShortIntToBool extends
        net.mintern.functions.binary.checked.ShortIntToBoolE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortIntToBoolE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortIntToBool unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortIntToBoolE<E> f) {
        return (sh, i) -> {
            try {
                return f.call(sh, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortIntToBool unchecked(
            net.mintern.functions.binary.checked.ShortIntToBoolE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortIntToBool uncheckedIO(
            net.mintern.functions.binary.checked.ShortIntToBoolE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> boolean}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (int i) -> boolean} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.unary.IntToBool
    bind(ShortIntToBool f, short sh) {
        return (i) -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> boolean}.
     *
     * @param sh argument 1
     * @return a new function {@code (int i) -> boolean} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToBool bind(short sh) {
        return ShortIntToBool.bind(this, sh);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToBool
    rbind(ShortIntToBool f, int i) {
        return (sh) -> f.call(sh, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param i argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToBool rbind(int i) {
        return ShortIntToBool.rbind(this, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToBool
    bind(ShortIntToBool f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToBool bind(short sh, int i) {
        return ShortIntToBool.bind(this, sh, i);
    }
}
