package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, int) -> R}.
 *
 * @param <R> the type of the return value
 */
@FunctionalInterface
public interface ShortIntToObj<R> extends
        net.mintern.functions.binary.checked.ShortIntToObjE<R, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortIntToObjE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <R, E extends Exception> ShortIntToObj<R> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortIntToObjE<R, E> f) {
        return (sh, i) -> {
            try {
                return f.call(sh, i);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <R, E extends Exception> ShortIntToObj<R> unchecked(
            net.mintern.functions.binary.checked.ShortIntToObjE<R, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <R, E extends java.io.IOException> ShortIntToObj<R> uncheckedIO(
            net.mintern.functions.binary.checked.ShortIntToObjE<R, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (int i) -> R} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <R> net.mintern.functions.unary.IntToObj<R>
    bind(ShortIntToObj<R> f, short sh) {
        return (i) -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> R}.
     *
     * @param sh argument 1
     * @return a new function {@code (int i) -> R} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.IntToObj<R> bind(short sh) {
        return ShortIntToObj.bind(this, sh);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <R> net.mintern.functions.unary.ShortToObj<R>
    rbind(ShortIntToObj<R> f, int i) {
        return (sh) -> f.call(sh, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param i argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToObj<R> rbind(int i) {
        return ShortIntToObj.rbind(this, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param f the unbound function
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <R> net.mintern.functions.nullary.NilToObj<R>
    bind(ShortIntToObj<R> f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToObj<R> bind(short sh, int i) {
        return ShortIntToObj.bind(this, sh, i);
    }
}
