package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, long) -> boolean}.
 *
 */
@FunctionalInterface
public interface ShortLongToBool extends
        net.mintern.functions.binary.checked.ShortLongToBoolE<RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortLongToBoolE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <E extends Exception> ShortLongToBool unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortLongToBoolE<E> f) {
        return (sh, l) -> {
            try {
                return f.call(sh, l);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <E extends Exception> ShortLongToBool unchecked(
            net.mintern.functions.binary.checked.ShortLongToBoolE<E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <E extends java.io.IOException> ShortLongToBool uncheckedIO(
            net.mintern.functions.binary.checked.ShortLongToBoolE<E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> boolean}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (long l) -> boolean} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static  net.mintern.functions.unary.LongToBool
    bind(ShortLongToBool f, short sh) {
        return (l) -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> boolean}.
     *
     * @param sh argument 1
     * @return a new function {@code (long l) -> boolean} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.LongToBool bind(short sh) {
        return ShortLongToBool.bind(this, sh);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static  net.mintern.functions.unary.ShortToBool
    rbind(ShortLongToBool f, long l) {
        return (sh) -> f.call(sh, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param l argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToBool rbind(long l) {
        return ShortLongToBool.rbind(this, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param f the unbound function
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static  net.mintern.functions.nullary.NilToBool
    bind(ShortLongToBool f, short sh, long l) {
        return () -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToBool bind(short sh, long l) {
        return ShortLongToBool.bind(this, sh, l);
    }
}
