package net.mintern.functions.binary;

/**
 * An operation of type {@code (short, U) -> long}.
 *
 * @param <U> the type of the argument
 */
@FunctionalInterface
public interface ShortObjToLong<U> extends
        net.mintern.functions.binary.checked.ShortObjToLongE<U, RuntimeException> {

    /**
     * Returns a wrapped version of {@code f} that uses {@code toRuntime} to convert any checked
     * {@code Exception} to a {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param toRuntime if a checked exception is thrown from
     *      {@link net.mintern.functions.binary.checked.ShortObjToLongE#call}, then this function
     *      is called in in order to convert it to a {@code RuntimeException}
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    @SuppressWarnings("unchecked")
    static <U, E extends Exception> ShortObjToLong<U> unchecked(
            java.util.function.Function<? super E, RuntimeException> toRuntime,
            net.mintern.functions.binary.checked.ShortObjToLongE<U, E> f) {
        return (sh, u) -> {
            try {
                return f.call(sh, u);
            } catch (RuntimeException e) {
                throw e;
            } catch (Exception e) {
                throw toRuntime.apply((E) e);
            }
        };
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any checked {@code Exception} with a
     * {@code RuntimeException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that does not throw checked exceptions
     */
    static <U, E extends Exception> ShortObjToLong<U> unchecked(
            net.mintern.functions.binary.checked.ShortObjToLongE<U, E> f) {
        return unchecked(RuntimeException::new, f);
    }

    /**
     * Returns a wrapped version of {@code f} that wraps any {@code IOException} with an
     * {@link java.io.UncheckedIOException}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the operation to wrap
     * @return a wrapped version of {@code f} that throws {@code UncheckedIOException} instead of
     *      {@code IOException}
     */
    static <U, E extends java.io.IOException> ShortObjToLong<U> uncheckedIO(
            net.mintern.functions.binary.checked.ShortObjToLongE<U, E> f) {
        return unchecked(java.io.UncheckedIOException::new, f);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> long}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (U u) -> long} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ObjToLong<U>
    bind(ShortObjToLong<U> f, short sh) {
        return (u) -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> long}.
     *
     * @param sh argument 1
     * @return a new function {@code (U u) -> long} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ObjToLong<U> bind(short sh) {
        return ShortObjToLong.bind(this, sh);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U> net.mintern.functions.unary.ShortToLong
    rbind(ShortObjToLong<U> f, U u) {
        return (sh) -> f.call(sh, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param u argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.unary.ShortToLong rbind(U u) {
        return ShortObjToLong.rbind(this, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <U> the type of the argument
     * @param f the unbound function
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(sh, u)} and returns the result.
     */
    static <U> net.mintern.functions.nullary.NilToLong
    bind(ShortObjToLong<U> f, short sh, U u) {
        return () -> f.call(sh, u);
    }

    /**
     * Binds {@code (sh, u)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param sh argument 1
     * @param u argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(sh, u)} and returns the result.
     */
    @Override
    default net.mintern.functions.nullary.NilToLong bind(short sh, U u) {
        return ShortObjToLong.bind(this, sh, u);
    }
}
