package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, byte) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolByteToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param b argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(boolean bool, byte b) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(bool, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    bind(BoolByteToShortE<E> f, boolean bool) {
        return (b) -> f.call(bool, b);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(bool, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> bind(boolean bool) {
        return BoolByteToShortE.bind(this, bool);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    rbind(BoolByteToShortE<E> f, byte b) {
        return (bool) -> f.call(bool, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param b argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> rbind(byte b) {
        return BoolByteToShortE.rbind(this, b);
    }

    /**
     * Binds {@code (bool, b)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(BoolByteToShortE<E> f, boolean bool, byte b) {
        return () -> f.call(bool, b);
    }

    /**
     * Binds {@code (bool, b)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, b)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(boolean bool, byte b) {
        return BoolByteToShortE.bind(this, bool, b);
    }
}
