package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, float) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolFloatToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(boolean bool, float fl) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(bool, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    bind(BoolFloatToShortE<E> f, boolean bool) {
        return (fl) -> f.call(bool, fl);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(bool, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> bind(boolean bool) {
        return BoolFloatToShortE.bind(this, bool);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    rbind(BoolFloatToShortE<E> f, float fl) {
        return (bool) -> f.call(bool, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> rbind(float fl) {
        return BoolFloatToShortE.rbind(this, fl);
    }

    /**
     * Binds {@code (bool, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(BoolFloatToShortE<E> f, boolean bool, float fl) {
        return () -> f.call(bool, fl);
    }

    /**
     * Binds {@code (bool, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(boolean bool, float fl) {
        return BoolFloatToShortE.bind(this, bool, fl);
    }
}
