package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, long) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolLongToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(boolean bool, long l) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(bool, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    bind(BoolLongToShortE<E> f, boolean bool) {
        return (l) -> f.call(bool, l);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param bool argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(bool, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> bind(boolean bool) {
        return BoolLongToShortE.bind(this, bool);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(bool, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    rbind(BoolLongToShortE<E> f, long l) {
        return (bool) -> f.call(bool, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(bool, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> rbind(long l) {
        return BoolLongToShortE.rbind(this, l);
    }

    /**
     * Binds {@code (bool, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(bool, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(BoolLongToShortE<E> f, boolean bool, long l) {
        return () -> f.call(bool, l);
    }

    /**
     * Binds {@code (bool, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param bool argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(bool, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(boolean bool, long l) {
        return BoolLongToShortE.bind(this, bool, l);
    }
}
