package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, short) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolShortToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(boolean bool, short sh) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToDblE<E>
    bind(BoolShortToDblE<E> f, boolean bool) {
        return (sh) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param bool argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToDblE<E> bind(boolean bool) {
        return BoolShortToDblE.bind(this, bool);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> double} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToDblE<E>
    rbind(BoolShortToDblE<E> f, short sh) {
        return (bool) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> double}.
     *
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> double} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToDblE<E> rbind(short sh) {
        return BoolShortToDblE.rbind(this, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(BoolShortToDblE<E> f, boolean bool, short sh) {
        return () -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(boolean bool, short sh) {
        return BoolShortToDblE.bind(this, bool, sh);
    }
}
