package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, short) -> float}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolShortToFloatE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    float call(boolean bool, short sh) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToFloatE<E>
    bind(BoolShortToFloatE<E> f, boolean bool) {
        return (sh) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param bool argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToFloatE<E> bind(boolean bool) {
        return BoolShortToFloatE.bind(this, bool);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> float} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToFloatE<E>
    rbind(BoolShortToFloatE<E> f, short sh) {
        return (bool) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> float}.
     *
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> float} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToFloatE<E> rbind(short sh) {
        return BoolShortToFloatE.rbind(this, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToFloatE<E>
    bind(BoolShortToFloatE<E> f, boolean bool, short sh) {
        return () -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToFloatE<E> bind(boolean bool, short sh) {
        return BoolShortToFloatE.bind(this, bool, sh);
    }
}
