package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, short) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolShortToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(boolean bool, short sh) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    bind(BoolShortToLongE<E> f, boolean bool) {
        return (sh) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param bool argument 1
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> bind(boolean bool) {
        return BoolShortToLongE.bind(this, bool);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> long} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToLongE<E>
    rbind(BoolShortToLongE<E> f, short sh) {
        return (bool) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> long}.
     *
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> long} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToLongE<E> rbind(short sh) {
        return BoolShortToLongE.rbind(this, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(bool, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(BoolShortToLongE<E> f, boolean bool, short sh) {
        return () -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(bool, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(boolean bool, short sh) {
        return BoolShortToLongE.bind(this, bool, sh);
    }
}
