package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (boolean, short) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface BoolShortToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @throws E if the operation cannot be completed
     */
    void call(boolean bool, short sh) throws E;

    /**
     * Binds {@code (bool)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(bool, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    bind(BoolShortToNilE<E> f, boolean bool) {
        return (sh) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param bool argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(bool, sh)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> bind(boolean bool) {
        return BoolShortToNilE.bind(this, bool);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (boolean) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> void} that calls
     *      {@code f.call(bool, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToNilE<E>
    rbind(BoolShortToNilE<E> f, short sh) {
        return (bool) -> f.call(bool, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (boolean) -> void}.
     *
     * @param sh argument 2
     * @return a new function {@code (boolean bool) -> void} that calls
     *      {@code this.call(bool, sh)}.
     */
    default net.mintern.functions.unary.checked.BoolToNilE<E> rbind(short sh) {
        return BoolShortToNilE.rbind(this, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(bool, sh)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(BoolShortToNilE<E> f, boolean bool, short sh) {
        return () -> f.call(bool, sh);
    }

    /**
     * Binds {@code (bool, sh)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param bool argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(bool, sh)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(boolean bool, short sh) {
        return BoolShortToNilE.bind(this, bool, sh);
    }
}
