package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, boolean) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteBoolToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param bool argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(byte b, boolean bool) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(b, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    bind(ByteBoolToShortE<E> f, byte b) {
        return (bool) -> f.call(b, bool);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(b, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> bind(byte b) {
        return ByteBoolToShortE.bind(this, b);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    rbind(ByteBoolToShortE<E> f, boolean bool) {
        return (b) -> f.call(b, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> rbind(boolean bool) {
        return ByteBoolToShortE.rbind(this, bool);
    }

    /**
     * Binds {@code (b, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ByteBoolToShortE<E> f, byte b, boolean bool) {
        return () -> f.call(b, bool);
    }

    /**
     * Binds {@code (b, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, bool)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(byte b, boolean bool) {
        return ByteBoolToShortE.bind(this, b, bool);
    }
}
