package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, double) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteDblToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(byte b, double d) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(b, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    bind(ByteDblToShortE<E> f, byte b) {
        return (d) -> f.call(b, d);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(b, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> bind(byte b) {
        return ByteDblToShortE.bind(this, b);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    rbind(ByteDblToShortE<E> f, double d) {
        return (b) -> f.call(b, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> rbind(double d) {
        return ByteDblToShortE.rbind(this, d);
    }

    /**
     * Binds {@code (b, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ByteDblToShortE<E> f, byte b, double d) {
        return () -> f.call(b, d);
    }

    /**
     * Binds {@code (b, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(byte b, double d) {
        return ByteDblToShortE.bind(this, b, d);
    }
}
