package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, float) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteFloatToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(byte b, float fl) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(b, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    bind(ByteFloatToShortE<E> f, byte b) {
        return (fl) -> f.call(b, fl);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param b argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(b, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> bind(byte b) {
        return ByteFloatToShortE.bind(this, b);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(b, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    rbind(ByteFloatToShortE<E> f, float fl) {
        return (b) -> f.call(b, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(b, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> rbind(float fl) {
        return ByteFloatToShortE.rbind(this, fl);
    }

    /**
     * Binds {@code (b, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(b, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ByteFloatToShortE<E> f, byte b, float fl) {
        return () -> f.call(b, fl);
    }

    /**
     * Binds {@code (b, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param b argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(b, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(byte b, float fl) {
        return ByteFloatToShortE.bind(this, b, fl);
    }
}
