package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, short) -> char}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteShortToCharE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    char call(byte b, short sh) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToCharE<E>
    bind(ByteShortToCharE<E> f, byte b) {
        return (sh) -> f.call(b, sh);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param b argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToCharE<E> bind(byte b) {
        return ByteShortToCharE.bind(this, b);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (byte b) -> char} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToCharE<E>
    rbind(ByteShortToCharE<E> f, short sh) {
        return (b) -> f.call(b, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> char}.
     *
     * @param sh argument 2
     * @return a new function {@code (byte b) -> char} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToCharE<E> rbind(short sh) {
        return ByteShortToCharE.rbind(this, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToCharE<E>
    bind(ByteShortToCharE<E> f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToCharE<E> bind(byte b, short sh) {
        return ByteShortToCharE.bind(this, b, sh);
    }
}
