package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, short) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteShortToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(byte b, short sh) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToDblE<E>
    bind(ByteShortToDblE<E> f, byte b) {
        return (sh) -> f.call(b, sh);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param b argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToDblE<E> bind(byte b) {
        return ByteShortToDblE.bind(this, b);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (byte b) -> double} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToDblE<E>
    rbind(ByteShortToDblE<E> f, short sh) {
        return (b) -> f.call(b, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> double}.
     *
     * @param sh argument 2
     * @return a new function {@code (byte b) -> double} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToDblE<E> rbind(short sh) {
        return ByteShortToDblE.rbind(this, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(ByteShortToDblE<E> f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(byte b, short sh) {
        return ByteShortToDblE.bind(this, b, sh);
    }
}
