package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, boolean) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharBoolToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param bool argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(char ch, boolean bool) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(ch, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    bind(CharBoolToShortE<E> f, char ch) {
        return (bool) -> f.call(ch, bool);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(ch, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> bind(char ch) {
        return CharBoolToShortE.bind(this, ch);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    rbind(CharBoolToShortE<E> f, boolean bool) {
        return (ch) -> f.call(ch, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> rbind(boolean bool) {
        return CharBoolToShortE.rbind(this, bool);
    }

    /**
     * Binds {@code (ch, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(CharBoolToShortE<E> f, char ch, boolean bool) {
        return () -> f.call(ch, bool);
    }

    /**
     * Binds {@code (ch, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, bool)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(char ch, boolean bool) {
        return CharBoolToShortE.bind(this, ch, bool);
    }
}
