package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, double) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharDblToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(char ch, double d) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(ch, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    bind(CharDblToShortE<E> f, char ch) {
        return (d) -> f.call(ch, d);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(ch, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> bind(char ch) {
        return CharDblToShortE.bind(this, ch);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    rbind(CharDblToShortE<E> f, double d) {
        return (ch) -> f.call(ch, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> rbind(double d) {
        return CharDblToShortE.rbind(this, d);
    }

    /**
     * Binds {@code (ch, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(CharDblToShortE<E> f, char ch, double d) {
        return () -> f.call(ch, d);
    }

    /**
     * Binds {@code (ch, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(char ch, double d) {
        return CharDblToShortE.bind(this, ch, d);
    }
}
