package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, int) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharIntToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(char ch, int i) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(ch, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    bind(CharIntToShortE<E> f, char ch) {
        return (i) -> f.call(ch, i);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(ch, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> bind(char ch) {
        return CharIntToShortE.bind(this, ch);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    rbind(CharIntToShortE<E> f, int i) {
        return (ch) -> f.call(ch, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> rbind(int i) {
        return CharIntToShortE.rbind(this, i);
    }

    /**
     * Binds {@code (ch, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(CharIntToShortE<E> f, char ch, int i) {
        return () -> f.call(ch, i);
    }

    /**
     * Binds {@code (ch, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(char ch, int i) {
        return CharIntToShortE.bind(this, ch, i);
    }
}
