package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, U) -> short}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharObjToShortE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(char ch, U u) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(ch, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<U, E>
    bind(CharObjToShortE<U, E> f, char ch) {
        return (u) -> f.call(ch, u);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(ch, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<U, E> bind(char ch) {
        return CharObjToShortE.bind(this, ch);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    rbind(CharObjToShortE<U, E> f, U u) {
        return (ch) -> f.call(ch, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> rbind(U u) {
        return CharObjToShortE.rbind(this, u);
    }

    /**
     * Binds {@code (ch, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(CharObjToShortE<U, E> f, char ch, U u) {
        return () -> f.call(ch, u);
    }

    /**
     * Binds {@code (ch, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(char ch, U u) {
        return CharObjToShortE.bind(this, ch, u);
    }
}
