package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, short) -> boolean}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharShortToBoolE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    boolean call(char ch, short sh) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToBoolE<E>
    bind(CharShortToBoolE<E> f, char ch) {
        return (sh) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param ch argument 1
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToBoolE<E> bind(char ch) {
        return CharShortToBoolE.bind(this, ch);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (char ch) -> boolean} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToBoolE<E>
    rbind(CharShortToBoolE<E> f, short sh) {
        return (ch) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> boolean}.
     *
     * @param sh argument 2
     * @return a new function {@code (char ch) -> boolean} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToBoolE<E> rbind(short sh) {
        return CharShortToBoolE.rbind(this, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToBoolE<E>
    bind(CharShortToBoolE<E> f, char ch, short sh) {
        return () -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToBoolE<E> bind(char ch, short sh) {
        return CharShortToBoolE.bind(this, ch, sh);
    }
}
