package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, short) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharShortToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(char ch, short sh) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    bind(CharShortToLongE<E> f, char ch) {
        return (sh) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param ch argument 1
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> bind(char ch) {
        return CharShortToLongE.bind(this, ch);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (char ch) -> long} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToLongE<E>
    rbind(CharShortToLongE<E> f, short sh) {
        return (ch) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> long}.
     *
     * @param sh argument 2
     * @return a new function {@code (char ch) -> long} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToLongE<E> rbind(short sh) {
        return CharShortToLongE.rbind(this, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(CharShortToLongE<E> f, char ch, short sh) {
        return () -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(char ch, short sh) {
        return CharShortToLongE.bind(this, ch, sh);
    }
}
