package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, short) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharShortToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @throws E if the operation cannot be completed
     */
    void call(char ch, short sh) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(ch, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    bind(CharShortToNilE<E> f, char ch) {
        return (sh) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param ch argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(ch, sh)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> bind(char ch) {
        return CharShortToNilE.bind(this, ch);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (char ch) -> void} that calls
     *      {@code f.call(ch, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToNilE<E>
    rbind(CharShortToNilE<E> f, short sh) {
        return (ch) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> void}.
     *
     * @param sh argument 2
     * @return a new function {@code (char ch) -> void} that calls
     *      {@code this.call(ch, sh)}.
     */
    default net.mintern.functions.unary.checked.CharToNilE<E> rbind(short sh) {
        return CharShortToNilE.rbind(this, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(ch, sh)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(CharShortToNilE<E> f, char ch, short sh) {
        return () -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(ch, sh)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(char ch, short sh) {
        return CharShortToNilE.bind(this, ch, sh);
    }
}
