package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, short) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharShortToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(char ch, short sh) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    bind(CharShortToObjE<R, E> f, char ch) {
        return (sh) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param ch argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> bind(char ch) {
        return CharShortToObjE.bind(this, ch);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (char ch) -> R} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.CharToObjE<R, E>
    rbind(CharShortToObjE<R, E> f, short sh) {
        return (ch) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> R}.
     *
     * @param sh argument 2
     * @return a new function {@code (char ch) -> R} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToObjE<R, E> rbind(short sh) {
        return CharShortToObjE.rbind(this, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(CharShortToObjE<R, E> f, char ch, short sh) {
        return () -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(char ch, short sh) {
        return CharShortToObjE.bind(this, ch, sh);
    }
}
