package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, short) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharShortToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(char ch, short sh) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToShortE<E>
    bind(CharShortToShortE<E> f, char ch) {
        return (sh) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToShortE<E> bind(char ch) {
        return CharShortToShortE.bind(this, ch);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    rbind(CharShortToShortE<E> f, short sh) {
        return (ch) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param sh argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> rbind(short sh) {
        return CharShortToShortE.rbind(this, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(CharShortToShortE<E> f, char ch, short sh) {
        return () -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(char ch, short sh) {
        return CharShortToShortE.bind(this, ch, sh);
    }
}
