package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, boolean) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblBoolToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param bool argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(double d, boolean bool) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(d, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    bind(DblBoolToShortE<E> f, double d) {
        return (bool) -> f.call(d, bool);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(d, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> bind(double d) {
        return DblBoolToShortE.bind(this, d);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    rbind(DblBoolToShortE<E> f, boolean bool) {
        return (d) -> f.call(d, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> rbind(boolean bool) {
        return DblBoolToShortE.rbind(this, bool);
    }

    /**
     * Binds {@code (d, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(DblBoolToShortE<E> f, double d, boolean bool) {
        return () -> f.call(d, bool);
    }

    /**
     * Binds {@code (d, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, bool)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(double d, boolean bool) {
        return DblBoolToShortE.bind(this, d, bool);
    }
}
