package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, byte) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblByteToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param b argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(double d, byte b) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(d, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    bind(DblByteToShortE<E> f, double d) {
        return (b) -> f.call(d, b);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(d, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> bind(double d) {
        return DblByteToShortE.bind(this, d);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    rbind(DblByteToShortE<E> f, byte b) {
        return (d) -> f.call(d, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param b argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> rbind(byte b) {
        return DblByteToShortE.rbind(this, b);
    }

    /**
     * Binds {@code (d, b)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(DblByteToShortE<E> f, double d, byte b) {
        return () -> f.call(d, b);
    }

    /**
     * Binds {@code (d, b)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, b)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(double d, byte b) {
        return DblByteToShortE.bind(this, d, b);
    }
}
