package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, char) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblCharToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(double d, char ch) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(d, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    bind(DblCharToShortE<E> f, double d) {
        return (ch) -> f.call(d, ch);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(d, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> bind(double d) {
        return DblCharToShortE.bind(this, d);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    rbind(DblCharToShortE<E> f, char ch) {
        return (d) -> f.call(d, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> rbind(char ch) {
        return DblCharToShortE.rbind(this, ch);
    }

    /**
     * Binds {@code (d, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(DblCharToShortE<E> f, double d, char ch) {
        return () -> f.call(d, ch);
    }

    /**
     * Binds {@code (d, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(double d, char ch) {
        return DblCharToShortE.bind(this, d, ch);
    }
}
