package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, short) -> int}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblShortToIntE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    int call(double d, short sh) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToIntE<E>
    bind(DblShortToIntE<E> f, double d) {
        return (sh) -> f.call(d, sh);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param d argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToIntE<E> bind(double d) {
        return DblShortToIntE.bind(this, d);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (double d) -> int} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToIntE<E>
    rbind(DblShortToIntE<E> f, short sh) {
        return (d) -> f.call(d, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> int}.
     *
     * @param sh argument 2
     * @return a new function {@code (double d) -> int} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToIntE<E> rbind(short sh) {
        return DblShortToIntE.rbind(this, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToIntE<E>
    bind(DblShortToIntE<E> f, double d, short sh) {
        return () -> f.call(d, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToIntE<E> bind(double d, short sh) {
        return DblShortToIntE.bind(this, d, sh);
    }
}
