package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, short) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblShortToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param sh argument 2
     * @throws E if the operation cannot be completed
     */
    void call(double d, short sh) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(d, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    bind(DblShortToNilE<E> f, double d) {
        return (sh) -> f.call(d, sh);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param d argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(d, sh)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> bind(double d) {
        return DblShortToNilE.bind(this, d);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (double d) -> void} that calls
     *      {@code f.call(d, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToNilE<E>
    rbind(DblShortToNilE<E> f, short sh) {
        return (d) -> f.call(d, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> void}.
     *
     * @param sh argument 2
     * @return a new function {@code (double d) -> void} that calls
     *      {@code this.call(d, sh)}.
     */
    default net.mintern.functions.unary.checked.DblToNilE<E> rbind(short sh) {
        return DblShortToNilE.rbind(this, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(d, sh)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(DblShortToNilE<E> f, double d, short sh) {
        return () -> f.call(d, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(d, sh)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(double d, short sh) {
        return DblShortToNilE.bind(this, d, sh);
    }
}
