package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, short) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblShortToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(double d, short sh) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToShortE<E>
    bind(DblShortToShortE<E> f, double d) {
        return (sh) -> f.call(d, sh);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToShortE<E> bind(double d) {
        return DblShortToShortE.bind(this, d);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    rbind(DblShortToShortE<E> f, short sh) {
        return (d) -> f.call(d, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param sh argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> rbind(short sh) {
        return DblShortToShortE.rbind(this, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(DblShortToShortE<E> f, double d, short sh) {
        return () -> f.call(d, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(double d, short sh) {
        return DblShortToShortE.bind(this, d, sh);
    }
}
