package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, boolean) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatBoolToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param bool argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(float fl, boolean bool) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(fl, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    bind(FloatBoolToShortE<E> f, float fl) {
        return (bool) -> f.call(fl, bool);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(fl, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> bind(float fl) {
        return FloatBoolToShortE.bind(this, fl);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    rbind(FloatBoolToShortE<E> f, boolean bool) {
        return (fl) -> f.call(fl, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> rbind(boolean bool) {
        return FloatBoolToShortE.rbind(this, bool);
    }

    /**
     * Binds {@code (fl, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(FloatBoolToShortE<E> f, float fl, boolean bool) {
        return () -> f.call(fl, bool);
    }

    /**
     * Binds {@code (fl, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, bool)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(float fl, boolean bool) {
        return FloatBoolToShortE.bind(this, fl, bool);
    }
}
