package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, float) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatFloatToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl1 argument 1
     * @param fl2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(float fl1, float fl2) throws E;

    /**
     * Binds {@code (fl1)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl1 argument 1
     * @return a new function {@code (float fl2) -> short} that calls
     *      {@code f.call(fl1, fl2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    bind(FloatFloatToShortE<E> f, float fl1) {
        return (fl2) -> f.call(fl1, fl2);
    }

    /**
     * Binds {@code (fl1)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param fl1 argument 1
     * @return a new function {@code (float fl2) -> short} that calls
     *      {@code this.call(fl1, fl2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> bind(float fl1) {
        return FloatFloatToShortE.bind(this, fl1);
    }

    /**
     * Binds {@code (fl2)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl2 argument 2
     * @return a new function {@code (float fl1) -> short} that calls
     *      {@code f.call(fl1, fl2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    rbind(FloatFloatToShortE<E> f, float fl2) {
        return (fl1) -> f.call(fl1, fl2);
    }

    /**
     * Binds {@code (fl2)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param fl2 argument 2
     * @return a new function {@code (float fl1) -> short} that calls
     *      {@code this.call(fl1, fl2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> rbind(float fl2) {
        return FloatFloatToShortE.rbind(this, fl2);
    }

    /**
     * Binds {@code (fl1, fl2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl1 argument 1
     * @param fl2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl1, fl2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(FloatFloatToShortE<E> f, float fl1, float fl2) {
        return () -> f.call(fl1, fl2);
    }

    /**
     * Binds {@code (fl1, fl2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl1 argument 1
     * @param fl2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl1, fl2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(float fl1, float fl2) {
        return FloatFloatToShortE.bind(this, fl1, fl2);
    }
}
